function PS_dist = PS_dist(i,Mi,Mip)

% Computes the distance |Mi,Mip| as defined in the paper.

%-------
% setup
%-------

% global

global beta plr Pr_data x_data n NA NY NW jstate

% local

dist_cmp = zeros(1,NW(i));

%-------------
% computation
%-------------

for wi=1:NW(i) % compute dist_cmp(wi) := dist b/w Mi(wi) and Mip(wi)

    if (xor(Mi(wi).emp==1,Mip(wi).emp==1))  % only one is empty
        
        dist_cmp(wi) = 1.0;
    
    elseif (Mi(wi).emp==1&&Mip(wi).emp==1) % both are empty
            
        dist_cmp(wi) = 0.0;
    
    else % both are non-empty
        
        dist_cmp(wi) = hausdorff(Mi(wi).ext,Mip(wi).ext);
        
    end
    
end

PS_dist = max(dist_cmp); % dist b/w Mi and Mip 
